/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.CefInitEvent;
import net.montoyo.mcef.client.AppHandler;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.client.DisplayHandler;
import net.montoyo.mcef.client.init.CefInitMenu;
import net.montoyo.mcef.remote.RemoteConfig;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.slf4j.Logger;

public final class CefUtil {
    public static boolean init;
    private static boolean ready;
    private static final Logger LOGGER;
    private static boolean ran;

    private CefUtil() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean init() {
        AppHandler appHandler = ClientProxy.appHandler;
        boolean VIRTUAL = false;
        DisplayHandler displayHandler = ClientProxy.displayHandler;
        appHandler.setArgs(MCEF.CEF_ARGS);
        String ROOT = ClientProxy.mc.f_91069_.getAbsolutePath().replaceAll("\\\\", "/");
        String JCEF_ROOT = ROOT + "/jcef";
        String LIBS_ROOT = ROOT + "/mods/cinemamod-libraries";
        if (ROOT.endsWith(".")) {
            ROOT = ROOT.substring(0, ROOT.length() - 1);
        }
        if (ROOT.endsWith("/")) {
            ROOT = ROOT.substring(0, ROOT.length() - 1);
        }
        File fileListing = new File(new File(ROOT), "config");
        RemoteConfig cfg = new RemoteConfig();
        IProgressListener ipl = CefInitMenu.listener;
        ipl.onProgressed(0.0);
        ipl.onTaskChanged("1:Load Config");
        if (!MCEF.FAVOR_GIT || !MCEF.downloadedFromGit) {
            cfg.load();
        }
        ipl.onProgressed(0.25);
        System.out.println("Updating MCEF file listing ");
        ipl.onProgressed(0.5);
        if (!cfg.updateFileListing(fileListing, false)) {
            Log.warning("There was a problem while establishing file list. Uninstall may not delete all files.", new Object[0]);
        }
        ipl.onProgressed(0.75);
        if (!cfg.updateFileListing(fileListing, true)) {
            Log.warning("There was a problem while updating file list. Uninstall may not delete all files.", new Object[0]);
        }
        ipl.onProgressed(1.0);
        ClientProxy.updateStr = cfg.getUpdateString();
        ipl.onProgressEnd();
        if (OS.isLinux()) {
            File[] subprocs = new File[]{new File(LIBS_ROOT, "jcef_helper"), new File(JCEF_ROOT, "jcef_helper")};
            boolean anyPassed = false;
            Throwable te = null;
            for (File subproc : subprocs) {
                if (!subproc.canExecute()) {
                    try {
                        int retCode = Runtime.getRuntime().exec(new String[]{"/usr/bin/chmod", "+x", subproc.getAbsolutePath()}).waitFor();
                        if (retCode != 0) continue;
                        anyPassed = true;
                        break;
                    }
                    catch (Throwable t) {
                        te = t;
                        continue;
                    }
                }
                anyPassed = true;
                break;
            }
            if (!anyPassed) {
                if (te != null) {
                    Log.errorEx("Error while giving execution rights to jcef_helper. MCEF will enter virtual mode. You can fix this by chmoding jcef_helper manually.", te, new Object[0]);
                } else {
                    Log.error("Error while giving execution rights to jcef_helper. MCEF will enter virtual mode. You can fix this by chmoding jcef_helper manually.", new Object[0]);
                }
                VIRTUAL = true;
            }
        }
        if (VIRTUAL) {
            return false;
        }
        CefSettings settings = new CefSettings();
        settings.windowless_rendering_enabled = true;
        CefSettings cefSettings = settings;
        Objects.requireNonNull(cefSettings);
        settings.background_color = new CefSettings.ColorType(cefSettings, 0, 255, 255, 255);
        settings.cache_path = new File(JCEF_ROOT, "cache").getAbsolutePath();
        CefApp.startup(MCEF.CEF_ARGS);
        CefApp cefApp = CefApp.getInstance(settings);
        if (!OS.isLinux()) {
            CefApp.addAppHandler(appHandler);
        }
        ClientProxy.loadMimeTypeMapping();
        ClientProxy.cefApp = cefApp;
        CefClient cefClient = cefApp.createClient();
        ClientProxy.cefApp = null;
        Log.info(cefApp.getVersion().toString(), new Object[0]);
        CefMessageRouter cefRouter = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("mcefQuery", "mcefCancel"));
        cefClient.addMessageRouter(cefRouter);
        cefClient.addDisplayHandler(displayHandler);
        cefClient.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

            @Override
            public boolean doClose(CefBrowser browser) {
                browser.close(true);
                return false;
            }
        });
        ClientProxy.cefApp = cefApp;
        ClientProxy.cefClient = cefClient;
        ClientProxy.cefRouter = cefRouter;
        Log.info("MCEF loaded successfuly.", new Object[0]);
        init = true;
        return true;
    }

    public static boolean isInit() {
        return init;
    }

    public static boolean isReady() {
        return ready;
    }

    public static void setReady() {
        ready = true;
    }

    public static void runInit() {
        if (OS.isLinux()) {
            String jvmPath = ProcessHandle.current().info().command().orElseThrow();
            jvmPath = jvmPath.replace("\\", "/");
            jvmPath = jvmPath.substring(0, jvmPath.lastIndexOf("/") - 4);
            System.load(jvmPath + "/lib/libjawt.so");
        }
        if ((OS.isWindows() || OS.isLinux()) && !ran) {
            if (CefUtil.init()) {
                MinecraftForge.EVENT_BUS.post((Event)new CefInitEvent(true));
                ran = true;
                LOGGER.info("Chromium Embedded Framework initialized");
            } else {
                ClientProxy.VIRTUAL = true;
                MinecraftForge.EVENT_BUS.post((Event)new CefInitEvent(false));
                ran = true;
                LOGGER.warn("Could not initialize Chromium Embedded Framework");
            }
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
        ran = false;
    }
}

